/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util.impl;

import com.ibm.hwmca.fw.servlet.util.impl.CustomizeDialog;
import com.ibm.hwmca.fw.servlet.util.impl.ExampleFileFilter;
import com.ibm.hwmca.fw.servlet.util.impl.GuiLogHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class LogOutputWindow {
    private SimpleAttributeSet[] attributes;
    GuiLogHandler logHandler;
    Preferences userPrefs;
    Listener listener;
    JFrame window;
    JTextPane textPane;
    JScrollPane scrollPane;
    JSplitPane splitPane;
    Document document;
    JButton closeButton;
    JButton clearButton;
    JButton customizeButton;
    JMenuItem saveMenuItem;
    JMenuItem aboutMenuItem;
    JCheckBox showSequence;
    JCheckBox showTime;
    JCheckBox showThread;
    JCheckBox showSource;
    JCheckBox showColors;
    ArrayList linePositions;
    boolean startOfLine = true;
    int linesToPreserve = 1000;
    boolean shouldShowColors;
    boolean scrollToBottomPending;
    private static final Level[] intToLevelMap = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private static final String[] intToNameMap = new String[]{"All", "Finest", "Finer", "Fine", "Config", "Info", "Warning", "Severe", "Off"};
    private Color[] defaultBackgroundColors;
    boolean[] defaultColorEnabled;
    private Color[] backgroundColors;
    boolean[] colorEnabled;
    private String lastStoreDir = ".";
    private boolean maximizeDividerAfterShow;

    public LogOutputWindow(GuiLogHandler logHandler, Preferences userPrefs) {
        this.logHandler = logHandler;
        this.userPrefs = userPrefs;
        this.shouldShowColors = userPrefs.getBoolean("guiloghandler.showColors", true);
        this.defaultBackgroundColors = new Color[intToLevelMap.length];
        this.defaultBackgroundColors[LogOutputWindow.levelToInt((Level)Level.FINEST)] = new Color(30, 140, 20);
        this.defaultBackgroundColors[LogOutputWindow.levelToInt((Level)Level.FINER)] = new Color(50, 170, 20);
        this.defaultBackgroundColors[LogOutputWindow.levelToInt((Level)Level.FINE)] = new Color(80, 200, 20);
        this.defaultBackgroundColors[LogOutputWindow.levelToInt((Level)Level.CONFIG)] = new Color(250, 204, 20);
        this.defaultBackgroundColors[LogOutputWindow.levelToInt((Level)Level.INFO)] = new Color(250, 153, 20);
        this.defaultBackgroundColors[LogOutputWindow.levelToInt((Level)Level.WARNING)] = new Color(250, 79, 20);
        this.defaultBackgroundColors[LogOutputWindow.levelToInt((Level)Level.SEVERE)] = Color.red;
        this.defaultColorEnabled = new boolean[intToLevelMap.length];
        this.defaultColorEnabled[LogOutputWindow.levelToInt((Level)Level.FINEST)] = false;
        this.defaultColorEnabled[LogOutputWindow.levelToInt((Level)Level.FINER)] = false;
        this.defaultColorEnabled[LogOutputWindow.levelToInt((Level)Level.FINE)] = false;
        this.defaultColorEnabled[LogOutputWindow.levelToInt((Level)Level.CONFIG)] = false;
        this.defaultColorEnabled[LogOutputWindow.levelToInt((Level)Level.INFO)] = false;
        this.defaultColorEnabled[LogOutputWindow.levelToInt((Level)Level.WARNING)] = true;
        this.defaultColorEnabled[LogOutputWindow.levelToInt((Level)Level.SEVERE)] = true;
        this.backgroundColors = new Color[this.defaultBackgroundColors.length];
        this.colorEnabled = new boolean[this.defaultColorEnabled.length];
        int last = LogOutputWindow.levelToInt(Level.SEVERE);
        for (int i = LogOutputWindow.levelToInt(Level.FINEST); i <= last; ++i) {
            this.checkColorOverride(i);
        }
        this.initializeAttributes();
        this.listener = new Listener();
    }

    private void checkColorOverride(int levelIndex) {
        this.backgroundColors[levelIndex] = this.defaultBackgroundColors[levelIndex];
        this.colorEnabled[levelIndex] = this.defaultColorEnabled[levelIndex];
        String prefname = "guiloghandler." + LogOutputWindow.intToName(levelIndex) + ".color";
        String colorDefn = this.userPrefs.get(prefname, null);
        if (colorDefn == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(colorDefn, ", ");
        int tokens = tokenizer.countTokens();
        if (tokens != 4 && tokens != 1) {
            this.userPrefs.remove(prefname);
            return;
        }
        boolean enabled = !tokenizer.nextToken().equalsIgnoreCase("false");
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            if (tokens > 1) {
                red = Integer.parseInt(tokenizer.nextToken());
                green = Integer.parseInt(tokenizer.nextToken());
                blue = Integer.parseInt(tokenizer.nextToken());
            }
        }
        catch (NumberFormatException e) {
            this.userPrefs.remove(prefname);
            return;
        }
        this.colorEnabled[levelIndex] = enabled;
        if (tokens > 1) {
            this.backgroundColors[levelIndex] = new Color(red, green, blue);
        }
    }

    private int getOutputLines() {
        return this.linesToPreserve;
    }

    void processCloseButton() {
        String[] messages = new String[]{"You will not be able to re-open the log window once it is closed.", "Do you wish to continue?"};
        this.window.getToolkit().beep();
        int answer = JOptionPane.showConfirmDialog(this.window, messages, "Window Close Confirmation", 0);
        if (answer != 0) {
            return;
        }
        this.setOutputWindowVisible(false);
    }

    void processCustomizeButton() {
        CustomizeDialog cd = new CustomizeDialog(this.window, this, this.backgroundColors, this.colorEnabled);
        if (cd.colorsResult == null) {
            return;
        }
        int last = LogOutputWindow.levelToInt(Level.SEVERE);
        for (int i = LogOutputWindow.levelToInt(Level.FINEST); i <= last; ++i) {
            String prefname = "guiloghandler." + LogOutputWindow.intToName(i) + ".color";
            boolean enabled = cd.enabledResult[i];
            Color newColor = cd.colorsResult[i];
            this.colorEnabled[i] = enabled;
            StyleConstants.setBackground(this.attributes[i], newColor);
            if (enabled == this.defaultColorEnabled[i] && newColor.equals(this.defaultBackgroundColors[i])) {
                this.userPrefs.remove(prefname);
                continue;
            }
            if (newColor.equals(this.defaultBackgroundColors[i])) {
                this.userPrefs.put(prefname, Boolean.toString(enabled));
                continue;
            }
            this.userPrefs.put(prefname, Boolean.toString(enabled) + ',' + newColor.getRed() + ',' + newColor.getGreen() + ',' + newColor.getBlue());
        }
    }

    Color getDefaultBackground(int levelIndex) {
        return this.defaultBackgroundColors[levelIndex];
    }

    boolean getDefaultEnablement(int levelIndex) {
        return this.defaultColorEnabled[levelIndex];
    }

    public void setOutputWindowVisible(boolean visible) {
        if (visible) {
            if (this.window == null) {
                this.initializeOutputWindow();
            }
            this.window.show();
            this.forceScrollToBottom();
            if (this.maximizeDividerAfterShow) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LogOutputWindow.this.maximizeDividerAfterShow = false;
                        LogOutputWindow.this.splitPane.setDividerLocation(LogOutputWindow.this.splitPane.getSize().height - LogOutputWindow.this.splitPane.getDividerSize() - LogOutputWindow.this.splitPane.getInsets().bottom);
                    }
                });
            }
        } else {
            this.window.hide();
        }
    }

    public boolean isOutputWindowVisible() {
        if (this.window == null) {
            return false;
        }
        return this.window.isVisible();
    }

    private void createMenu(JFrame window) {
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        this.saveMenuItem = new JMenuItem("Save...", 83);
        this.saveMenuItem.addActionListener(this.listener);
        m.add(this.saveMenuItem);
        mb.add(m);
        this.populateMenuBar(mb);
        m = new JMenu("Help");
        m.setMnemonic(72);
        this.aboutMenuItem = new JMenuItem("About Log Window...", 65);
        this.aboutMenuItem.addActionListener(this.listener);
        m.add(this.aboutMenuItem);
        mb.add(m);
        window.setJMenuBar(mb);
    }

    protected void populateMenuBar(JMenuBar mb) {
    }

    private synchronized void initializeOutputWindow() {
        int x;
        if (this.window != null) {
            return;
        }
        JFrame window = new JFrame("Log Output Window");
        window.setDefaultCloseOperation(0);
        window.addWindowListener(this.listener);
        window.addComponentListener(this.listener);
        this.createMenu(window);
        Container contentPane = window.getContentPane();
        this.splitPane = new JSplitPane(0, true);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.addPropertyChangeListener(this.listener);
        this.maximizeDividerAfterShow = this.userPrefs.getBoolean("guiloghandler.maximizeDivider", false);
        contentPane.add((Component)this.splitPane, "Center");
        this.textPane = new JTextPane();
        this.textPane.setFocusable(false);
        this.linePositions = new ArrayList(this.linesToPreserve + 2);
        this.textPane.setEditable(false);
        this.document = this.textPane.getDocument();
        this.scrollPane = new JScrollPane(this.textPane);
        this.splitPane.setTopComponent(this.scrollPane);
        JPanel optionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets.right = 15;
        c.insets.left = 15;
        c.insets.bottom = 8;
        c.insets.top = 8;
        Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
        ((Dictionary)sliderLabels).put(new Integer(0), new JLabel(LogOutputWindow.intToName(0)));
        ((Dictionary)sliderLabels).put(new Integer(1), new JLabel(LogOutputWindow.intToName(1)));
        ((Dictionary)sliderLabels).put(new Integer(2), new JLabel(LogOutputWindow.intToName(2)));
        ((Dictionary)sliderLabels).put(new Integer(3), new JLabel(LogOutputWindow.intToName(3)));
        ((Dictionary)sliderLabels).put(new Integer(4), new JLabel(LogOutputWindow.intToName(4)));
        ((Dictionary)sliderLabels).put(new Integer(5), new JLabel(LogOutputWindow.intToName(5)));
        ((Dictionary)sliderLabels).put(new Integer(6), new JLabel(LogOutputWindow.intToName(6)));
        ((Dictionary)sliderLabels).put(new Integer(7), new JLabel(LogOutputWindow.intToName(7)));
        ((Dictionary)sliderLabels).put(new Integer(8), new JLabel(LogOutputWindow.intToName(8)));
        JSlider slider = new JSlider(0, 8);
        slider.addChangeListener(this.listener);
        slider.setMajorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setSnapToTicks(true);
        slider.setLabelTable(sliderLabels);
        slider.setValue(LogOutputWindow.levelToInt(this.logHandler.getLevel()));
        optionPanel.add((Component)slider, c);
        c.insets.right = 0;
        c.insets.bottom = 0;
        c.insets.left = 0;
        c.insets.top = 0;
        c.fill = 0;
        c.anchor = 17;
        this.showSequence = new JCheckBox("Show sequence numbers.", this.logHandler.getShowSequence());
        this.showSequence.setMnemonic(81);
        this.showSequence.addItemListener(this.listener);
        c.gridwidth = -1;
        optionPanel.add((Component)this.showSequence, c);
        this.showTime = new JCheckBox("Show time stamps.", this.logHandler.getShowTime());
        this.showTime.setMnemonic(84);
        this.showTime.addItemListener(this.listener);
        c.gridwidth = 0;
        optionPanel.add((Component)this.showTime, c);
        this.showThread = new JCheckBox("Show thread ids.", this.logHandler.getShowThread());
        this.showThread.setMnemonic(87);
        this.showThread.addItemListener(this.listener);
        c.gridwidth = -1;
        optionPanel.add((Component)this.showThread, c);
        this.showSource = new JCheckBox("Show Java source locations.", this.logHandler.getShowSource());
        this.showSource.setMnemonic(83);
        this.showSource.addItemListener(this.listener);
        c.gridwidth = 0;
        optionPanel.add((Component)this.showSource, c);
        this.showColors = new JCheckBox("Show colors to indicate severity.", this.shouldShowColors);
        this.showColors.setMnemonic(79);
        this.showColors.addItemListener(this.listener);
        c.gridwidth = 0;
        optionPanel.add((Component)this.showColors, c);
        optionPanel.setMaximumSize(optionPanel.getPreferredSize());
        this.splitPane.setBottomComponent(optionPanel);
        JPanel buttonPanel = new JPanel();
        this.closeButton = new JButton("Close");
        this.closeButton.setMnemonic(67);
        this.closeButton.setToolTipText("Close the output messages window");
        this.closeButton.addActionListener(this.listener);
        buttonPanel.add(this.closeButton);
        this.clearButton = new JButton("Clear");
        this.clearButton.setMnemonic(76);
        this.clearButton.setToolTipText("Clear the output messages window");
        this.clearButton.addActionListener(this.listener);
        buttonPanel.add(this.clearButton);
        this.customizeButton = new JButton("Customize");
        this.customizeButton.setMnemonic(85);
        this.customizeButton.setToolTipText("Customize the colors used for log messages");
        this.customizeButton.addActionListener(this.listener);
        buttonPanel.add(this.customizeButton);
        contentPane.add((Component)buttonPanel, "South");
        String savedWindowBounds = this.userPrefs.get("guiloghandler.windowBounds", null);
        if (savedWindowBounds != null) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(savedWindowBounds, ",");
                if (tokenizer.countTokens() != 4) {
                    throw new Exception();
                }
                x = Integer.parseInt(tokenizer.nextToken());
                int y = Integer.parseInt(tokenizer.nextToken());
                int width = Integer.parseInt(tokenizer.nextToken());
                int height = Integer.parseInt(tokenizer.nextToken());
                window.setBounds(x, y, width, height);
            }
            catch (Exception e) {
                savedWindowBounds = null;
            }
        }
        if (savedWindowBounds == null) {
            Dimension screenSize = window.getToolkit().getScreenSize();
            x = screenSize.width - 600;
            window.setBounds(x, 0, 600, 500);
        }
        window.getRootPane().setDefaultButton(this.closeButton);
        this.window = window;
    }

    static int levelToInt(Level level) {
        for (int i = 0; i < intToLevelMap.length; ++i) {
            if (intToLevelMap[i] != level) continue;
            return i;
        }
        return -1;
    }

    static Level intToLevel(int level) {
        return intToLevelMap[level];
    }

    static String intToName(int level) {
        return intToNameMap[level];
    }

    protected synchronized void clearComponents() {
        this.textPane.setText("");
        this.linePositions.clear();
        this.startOfLine = true;
    }

    public synchronized void reset() {
        if (this.window == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    LogOutputWindow.this.reset();
                }
            }, "Reset on event thread");
            thread.setDaemon(true);
            thread.start();
            return;
        }
        this.window.dispose();
        this.textPane = null;
        this.document = null;
        this.linesToPreserve = 0;
        this.linePositions = null;
        this.startOfLine = true;
        this.clearButton = null;
        this.closeButton = null;
        this.aboutMenuItem = null;
        this.saveMenuItem = null;
        this.window = null;
    }

    public void addText(byte[] bytes, int offset, int length, Level level) {
        String text = new String(bytes, offset, length);
        this.addText(text, level);
    }

    public synchronized void forceScrollToBottom() {
        if (!this.scrollToBottomPending) {
            this.scrollToBottomPending = true;
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    LogOutputWindow logOutputWindow = LogOutputWindow.this;
                    synchronized (logOutputWindow) {
                        JScrollBar scrollBar = LogOutputWindow.this.scrollPane.getVerticalScrollBar();
                        scrollBar.setValue(scrollBar.getMaximum());
                        LogOutputWindow.this.scrollToBottomPending = false;
                    }
                }
            });
        }
    }

    public synchronized void addText(final String text, final Level level) {
        if (this.window == null) {
            this.setOutputWindowVisible(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogOutputWindow.this.addTextOnEventThread(text, level);
            }
        });
    }

    private synchronized void addTextOnEventThread(String text, Level level) {
        AttributeSet attribute = this.getAttributeForLevel(level);
        int beforeSize = this.document.getLength();
        try {
            this.document.insertString(beforeSize, text, attribute);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        this.updateLineInfo(beforeSize, text);
        JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
        scrollBar.setValue(scrollBar.getMaximum());
    }

    protected AttributeSet getAttributeForLevel(Level level) {
        int colorIndex = LogOutputWindow.levelToInt(level);
        if (!this.shouldShowColors || !this.colorEnabled[colorIndex]) {
            return this.attributes[0];
        }
        return this.attributes[LogOutputWindow.levelToInt(level)];
    }

    private synchronized void updateLineInfo(int startingIndex, String text) {
        try {
            int len = text.length();
            for (int offset = 0; offset < len; ++offset) {
                if (this.startOfLine) {
                    this.linePositions.add(this.document.createPosition(startingIndex + offset));
                    this.startOfLine = false;
                }
                if (text.charAt(offset) != '\n') continue;
                this.startOfLine = true;
            }
            this.trimLinesToSize();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private synchronized void saveWindowContents() {
        JFileChooser chooser = new JFileChooser(this.lastStoreDir);
        ExampleFileFilter filter = new ExampleFileFilter("txt", "Text files");
        chooser.addChoosableFileFilter(filter);
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setFileFilter(filter);
        int result = chooser.showSaveDialog(this.window);
        if (result != 0) {
            return;
        }
        this.lastStoreDir = chooser.getCurrentDirectory().getPath();
        this.userPrefs.put("guiloghandler.lastStoreDir", this.lastStoreDir);
        File outputFile = chooser.getSelectedFile();
        BufferedWriter out = null;
        try {
            String text = this.document.getText(0, this.document.getLength());
            out = new BufferedWriter(new FileWriter(outputFile));
            out.write(text);
            out.close();
        }
        catch (BadLocationException e) {
        }
        catch (IOException e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ee) {
                    // empty catch block
                }
            }
            this.window.getToolkit().beep();
            JOptionPane.showMessageDialog(this.window, "Error writing to \"" + outputFile.getPath() + "\".", "Save Error", 64);
        }
    }

    private synchronized void processChangeToOutputLines() {
        if (this.linePositions == null) {
            return;
        }
        this.linesToPreserve = this.getOutputLines();
        this.trimLinesToSize();
    }

    private synchronized void trimLinesToSize() {
        int currentSize = this.linePositions.size();
        if (this.linesToPreserve < currentSize) {
            int linesToDelete = currentSize - this.linesToPreserve;
            for (int i = 0; i < linesToDelete; ++i) {
                this.linePositions.remove(0);
            }
            try {
                this.document.remove(0, ((Position)this.linePositions.get(0)).getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private synchronized void initializeAttributes() {
        if (this.attributes != null) {
            return;
        }
        this.attributes = new SimpleAttributeSet[intToLevelMap.length];
        SimpleAttributeSet baseAttributes = new SimpleAttributeSet();
        StyleConstants.setFontFamily(baseAttributes, "monospaced");
        this.attributes[LogOutputWindow.levelToInt((Level)Level.ALL)] = baseAttributes;
        this.attributes[LogOutputWindow.levelToInt((Level)Level.OFF)] = baseAttributes;
        int last = LogOutputWindow.levelToInt(Level.SEVERE);
        for (int i = LogOutputWindow.levelToInt(Level.FINEST); i <= last; ++i) {
            SimpleAttributeSet attrs = new SimpleAttributeSet(baseAttributes);
            StyleConstants.setBackground(attrs, this.backgroundColors[i]);
            this.attributes[i] = attrs;
        }
    }

    private class Listener
    implements WindowListener,
    ChangeListener,
    ItemListener,
    ActionListener,
    PropertyChangeListener,
    ComponentListener {
        private Listener() {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowOpened(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            LogOutputWindow.this.setOutputWindowVisible(false);
        }

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void stateChanged(ChangeEvent e) {
            LogOutputWindow.this.logHandler.setLevel(LogOutputWindow.intToLevel(((JSlider)e.getSource()).getValue()));
        }

        public void itemStateChanged(ItemEvent e) {
            JCheckBox source = (JCheckBox)e.getSource();
            if (source == LogOutputWindow.this.showSource) {
                LogOutputWindow.this.logHandler.setShowSource(source.isSelected());
            } else if (source == LogOutputWindow.this.showSequence) {
                LogOutputWindow.this.logHandler.setShowSequence(source.isSelected());
            } else if (source == LogOutputWindow.this.showThread) {
                LogOutputWindow.this.logHandler.setShowThread(source.isSelected());
            } else if (source == LogOutputWindow.this.showTime) {
                LogOutputWindow.this.logHandler.setShowTime(source.isSelected());
            } else if (source == LogOutputWindow.this.showColors) {
                LogOutputWindow.this.shouldShowColors = source.isSelected();
                LogOutputWindow.this.userPrefs.putBoolean("guiloghandler.showColors", LogOutputWindow.this.shouldShowColors);
                try {
                    LogOutputWindow.this.userPrefs.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    // empty catch block
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == LogOutputWindow.this.closeButton) {
                LogOutputWindow.this.processCloseButton();
            } else if (source == LogOutputWindow.this.clearButton) {
                LogOutputWindow.this.clearComponents();
            } else if (source == LogOutputWindow.this.customizeButton) {
                LogOutputWindow.this.processCustomizeButton();
            } else if (source == LogOutputWindow.this.saveMenuItem) {
                LogOutputWindow.this.saveWindowContents();
            } else if (source == LogOutputWindow.this.aboutMenuItem) {
                JOptionPane.showMessageDialog(LogOutputWindow.this.window, "written by Jim Hennessy", "About Log Output Window", 1);
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            boolean isMaxed;
            String propertyName = e.getPropertyName();
            if (!propertyName.equals("dividerLocation")) {
                return;
            }
            boolean bl = isMaxed = LogOutputWindow.this.splitPane.getDividerLocation() == LogOutputWindow.this.splitPane.getSize().height - LogOutputWindow.this.splitPane.getDividerSize() - LogOutputWindow.this.splitPane.getInsets().bottom;
            if (isMaxed) {
                LogOutputWindow.this.userPrefs.putBoolean("guiloghandler.maximizeDivider", true);
            } else {
                LogOutputWindow.this.userPrefs.remove("guiloghandler.maximizeDivider");
            }
        }

        private String getWindowBounds() {
            Rectangle b = LogOutputWindow.this.window.getBounds();
            return Integer.toString(b.x) + ',' + b.y + ',' + b.width + ',' + b.height;
        }

        public void componentResized(ComponentEvent e) {
            if (LogOutputWindow.this.window == null) {
                return;
            }
            LogOutputWindow.this.userPrefs.put("guiloghandler.windowBounds", this.getWindowBounds());
        }

        public void componentMoved(ComponentEvent e) {
            if (LogOutputWindow.this.window == null) {
                return;
            }
            LogOutputWindow.this.userPrefs.put("guiloghandler.windowBounds", this.getWindowBounds());
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
        }
    }
}

